/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.epl;

import com.aptana.editor.iterators.CamelCaseWordIterator;
import com.aptana.editor.iterators.DocumentCharacterIterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.TextNavigationAction;

public abstract class AbstractBaseTextEditor
extends AbstractDecoratedTextEditor {

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected CamelCaseWordIterator fIterator;
        private String prefKey;

        protected NextSubWordAction(int code, String prefKey) {
            super(AbstractBaseTextEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CamelCaseWordIterator();
            this.prefKey = prefKey;
        }

        public void run() {
            IPreferenceStore store = AbstractBaseTextEditor.this.getPreferenceStore();
            if (!store.getBoolean(this.prefKey)) {
                super.run();
                return;
            }
            ISourceViewer viewer = AbstractBaseTextEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = AbstractBaseTextEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int next = this.findNextPosition(position);
                if (AbstractBaseTextEditor.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (Exception x) {
                super.run();
                return;
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = AbstractBaseTextEditor.this.getSourceViewer();
            int widget = -1;
            int next = position;
            while (next != -1 && widget == -1) {
                if ((next = this.fIterator.following(next)) == -1) continue;
                widget = AbstractBaseTextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)next);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && next != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
                    if (position != linkedPositionEnd && linkedPositionEnd < next) {
                        next = linkedPositionEnd;
                    }
                } else {
                    int nextLinkedPositionOffset;
                    LinkedPosition nextLinkedPosition = model.findPosition(new LinkedPosition(document, next, 0));
                    if (nextLinkedPosition != null && position != (nextLinkedPositionOffset = nextLinkedPosition.getOffset()) && nextLinkedPositionOffset < next) {
                        next = nextLinkedPositionOffset;
                    }
                }
            }
            return next;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected CamelCaseWordIterator fIterator;
        private String prefKey;

        protected PreviousSubWordAction(int code, String prefKey) {
            super(AbstractBaseTextEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CamelCaseWordIterator();
            this.prefKey = prefKey;
        }

        public void run() {
            IPreferenceStore store = AbstractBaseTextEditor.this.getPreferenceStore();
            if (!store.getBoolean(this.prefKey)) {
                super.run();
                return;
            }
            ISourceViewer viewer = AbstractBaseTextEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = AbstractBaseTextEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int previous = this.findPreviousPosition(position);
                if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (Exception x) {
                super.run();
                return;
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = AbstractBaseTextEditor.this.getSourceViewer();
            int widget = -1;
            int previous = position;
            while (previous != -1 && widget == -1) {
                if ((previous = this.fIterator.preceding(previous)) == -1) continue;
                widget = AbstractBaseTextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)previous);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && previous != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionOffset = linkedPosition.getOffset();
                    if (position != linkedPositionOffset && previous < linkedPositionOffset) {
                        previous = linkedPositionOffset;
                    }
                } else {
                    int previousLinkedPositionEnd;
                    LinkedPosition previousLinkedPosition = model.findPosition(new LinkedPosition(document, previous, 0));
                    if (previousLinkedPosition != null && position != (previousLinkedPositionEnd = previousLinkedPosition.getOffset() + previousLinkedPosition.getLength()) && previous < previousLinkedPositionEnd) {
                        previous = previousLinkedPositionEnd;
                    }
                }
            }
            return previous;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction(String prefKey) {
            super(17170436, prefKey);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = AbstractBaseTextEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = AbstractBaseTextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction(String prefKey) {
            super(17170435, prefKey);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = AbstractBaseTextEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = AbstractBaseTextEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }
}

